(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14126,        458]*)
(*NotebookOutlinePosition[     14826,        482]*)
(*  CellTagsIndexPosition[     14782,        478]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Ejercicio 1", "Subsubsection"],

Cell[TextData[{
  "Es claro que ",
  Cell[BoxData[
      \(TraditionalForm\`F[1] = \(F[2] = 1\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`F[3] = 2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`F[4] = 3\)]],
  "... \n",
  StyleBox["a)",
    FontWeight->"Bold"],
  " Establece ",
  StyleBox["razonadamente",
    FontSlant->"Italic"],
  " una relaci\[OAcute]n de recurrencia entre ",
  Cell[BoxData[
      \(TraditionalForm\`F[n], \ F[n - 1]\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`F[n - 2]\)]],
  ". Utiliza dicha relaci\[OAcute]n para que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calcule los n\[UAcute]meros de Fibonacci. Quiero que hagas esto de tres \
formas:\n",
  StyleBox["a1)",
    FontWeight->"Bold"],
  " Definiendo la relaci\[OAcute]n de recurrencia con las condiciones \
iniciales sin pedirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que recuerde los valores ya calculados.\n",
  StyleBox["a2)",
    FontWeight->"Bold"],
  " Definiendo dicha relaci\[OAcute]n de recurrencia con las condiciones \
iniciales de modo que cuando ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calcule un valor ",
  StyleBox["F",
    FontSlant->"Italic"],
  "[n] recuerde los anteriores.\n",
  StyleBox["a3)",
    FontWeight->"Bold"],
  " Con un bucle usando un \"For\" o un \"Do\".\n",
  StyleBox["a4)",
    FontWeight->"Bold"],
  " Compara, usando el comando \"Timing\", el tiempo que invierte ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " en calcular los primeros 30 n\[UAcute]meros de Fibonacci en cada caso. \n\
",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Calcula la soluci\[OAcute]n de dicha relaci\[OAcute]n de recurrencia y \
define una funci\[OAcute]n \"fib[n]\" que sea igual a dicha soluci\[OAcute]n \
(usa tambi\[EAcute]n \"Simplify\" para simplificarla y quitar \
ra\[IAcute]ces). Es decir, fib[n] te proporciona expl\[IAcute]citamente como \
funci\[OAcute]n de n el n\[UAcute]mero ",
  StyleBox["F",
    FontSlant->"Italic"],
  "[n]. Calcula con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " los primeros 30 valores de \"fib[n]\" y comprueba que coinciden con los \
antes obtenidos. "
}], "Text"],

Cell[TextData[{
  "Sugerencias. Ensaya como soluci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`x\^n\)]],
  " y deduce que ",
  StyleBox["x",
    FontSlant->"Italic"],
  " debe ser soluci\[OAcute]n de la ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 - x - 1 = 0\)]],
  ". Calcula con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dichas soluciones. Sean estas ",
  StyleBox["a",
    FontSlant->"Italic"],
  " y ",
  StyleBox["b",
    FontSlant->"Italic"],
  ". Comprueba con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que cualquier expresi\[OAcute]n de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\ a\^n + \(\[Beta]\ b\^n\ \)\)]],
  "donde \[Alpha] y \[Beta] son n\[UAcute]meros reales cualesquiera es soluci\
\[OAcute]n de la ecuaci\[OAcute]n de recurrencia (sin impopner que se cumplan \
las condiciones iniciales). Usa para ello \"FullSimplify[",
  StyleBox["expr1==expr2",
    FontSlant->"Italic"],
  "]\". En ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 5 puedes usar \"FullSimplify[",
  StyleBox["expr1==expr2,Assumptions",
    FontSlant->"Italic"],
  "]\" donde \"Assumptions\" puede ser una informaci\[OAcute]n sobre el tipo \
de variables que aparecen en \"expr1\" o \"expr2\", por ejemplo, \"",
  StyleBox["n\[Element]",
    FontSlant->"Italic"],
  "Integers\". Esto no funciona en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3 donde es preciso declarar expl\[IAcute]citamente que ",
  StyleBox["n",
    FontSlant->"Italic"],
  " es un entero y ampliar la funci\[OAcute]n IntegerQ como sigue: "
}], "Text"],

Cell[BoxData[{
    \(entero[x_] := IntegerQ[x]\), 
    \(entero[x_\ y_] := entero[x] && entero[y]\), 
    \(entero[x_\  + \ y_] := entero[x] && entero[y]\)}], "Input"],

Cell[BoxData[
    \(\(n /: IntegerQ[n] = True;\)\)], "Input"],

Cell[TextData[{
  "Calcula con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " \[Alpha] y \[Beta] (y simplif\[IAcute]calas) para que se cumplan las \
condiciones iniciales. Con alg\[UAcute]n detalle adicional ya puedes definir \
la funci\[OAcute]n fib[n]."
}], "Text"],

Cell[TextData[{
  StyleBox["c)",
    FontWeight->"Bold"],
  " Si tratas de calcular (con Mathematica 3) fib[126] ver\[AAcute]s que no \
devuelve de forma expl\[IAcute]cita un n\[UAcute]mero entero porque no \
realiza de forma completa la simplificaci\[OAcute]n. Puedes evitar esto de la \
siguiente forma. Uno de los valores ",
  StyleBox["a",
    FontSlant->"Italic"],
  " o ",
  StyleBox["b",
    FontSlant->"Italic"],
  " que has calculado antes es menor que 1 en valor absoluto; supongamos que \
sea ",
  StyleBox["a",
    FontSlant->"Italic"],
  " este valor. Entonces ",
  Cell[BoxData[
      \(TraditionalForm\`a\^n\)]],
  " converge r\[AAcute]pidamente a cero y, como fib[n] debe ser un entero, \
deducimos que fib[n] es el entero m\[AAcute]s pr\[OAcute]ximo a ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\ a^n + \(\[Beta]\ b^n\ \)\)]],
  ". La funci\[OAcute]n Round[x] proporciona el entero m\[AAcute]s \
pr\[OAcute]ximo a x. Puedes ahora modificar de forma apropiada la funci\
\[OAcute]n fib[n] para que su salida sea siempre de forma expl\[IAcute]cita \
un entero. Calcula con ella los primeros 130 n\[UAcute]meros de Fibonacci."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Soluci\[OAcute]n", "Subsubsection"],

Cell[BoxData[
    \(G[1] = \(G[2] = 1\); \nG[n_] := G[n - 2] + G[n - 1]\)], "Input"],

Cell[BoxData[
    \(Table[G[k], {k, 1, 30}] // Timing\)], "Input"],

Cell[TextData[{
  "Con la definici\[OAcute]n dada cada vez que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tiene que calcular un valor, pongamos G[10], debe aplicar recurrentemente \
la definici\[OAcute]n hasta llegar a G[2], G[1] y tiene que calcular todos \
los valores intermedios G[9], G[8],.. etc\[EAcute]tera. Por eso al pedirle \
que calcule todos los n\[UAcute]meros G[k] para 1\[LessEqual]k\[LessEqual]30 \
necesita calcular 27 veces G[3], 26 veces G[4], etc\[EAcute]tera, 3 veces \
G[28], 2 veces G[29], una vez G[30]. "
}], "Text"],

Cell[BoxData[
    \(F[1] = \(F[2] = 1\); \nF[n_] := \(F[n] = F[n - 2] + F[n - 1]\)\)], 
  "Input"],

Cell[BoxData[
    \(Table[F[k], {k, 1, 30}] // Timing\)], "Input"],

Cell[BoxData[
    \(fib[n_Integer?Positive] := 
      Module[{preprefib, prefib, nuevofib}, 
        preprefib = 1; \[IndentingNewLine]prefib = 
          1; \[IndentingNewLine]nuevofib = 2; \[IndentingNewLine]Do[
          preprefib = prefib; \[IndentingNewLine]prefib = 
            nuevofib; \[IndentingNewLine]nuevofib = 
            preprefib + prefib, {n - 3}]; \[IndentingNewLine]If[
          n \[LessEqual] 2, 1, nuevofib]]\)], "Input"],

Cell[BoxData[
    \(fib[1000] // Timing\)], "Input"],

Cell[TextData[{
  "Con la definici\[OAcute]n dada cada vez que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calcula un valor lo almacena por eso ahora necesita calcular cada valor \
una sola vez pues para calcular el valor siguiente utiliza el previamente \
calculado."
}], "Text"],

Cell[BoxData[
    \({a, b} = x /. Solve[x^2 - x - 1 == 0, x]\)], "Input"],

Cell[BoxData[
    \(FullSimplify[
      \[Alpha]*a\^\(n + 2\) + \[Beta]*b\^\(n + 2\) == 
        \((\[Alpha]*a\^\(n + 1\) + \[Beta]*b\^\(n + 1\))\) + 
          \((\[Alpha]*a\^n + \[Beta]*b\^n)\)]\)], "Input"],

Cell[BoxData[
    \(sol = 
      \(Solve[{\[Alpha]*a + \[Beta]*b, \[Alpha]*a\^2 + \[Beta]*b\^2} == {1, 
              1}, {\[Alpha], \[Beta]}]\)[\([1]\)]; 
    \n{\[Alpha], \[Beta]} = 
      FullSimplify[{\[Alpha] /. sol, \[Beta] /. sol}]\)], "Input"],

Cell[BoxData[
    \(fib[n_] := Simplify[\[Alpha]*a\^n + \[Beta]*b\^n]\)], "Input"],

Cell[BoxData[
    \(Table[fib[n], {n, 1, 30}]\)], "Input"],

Cell[BoxData[
    \(fib[126]\)], "Input"],

Cell[BoxData[
    \(prefib[n_] := Round[fib[n]]\)], "Input"],

Cell[BoxData[
    \(Table[prefib[n], {n, 126, 140}]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Subsubsection"],

Cell[TextData[{
  "Expresa la relaci\[OAcute]n de recurrencia del ejercicio anterior en la \
forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(u[n]\), "=", 
          RowBox[{
            StyleBox["A",
              FontSlant->"Italic"], 
            StyleBox[
              FormBox[
                StyleBox[\(u[n - 1]\),
                  FontWeight->"Plain"],
                "TraditionalForm"],
              FontWeight->"Bold"], "   ", \((n \[GreaterEqual] 2)\)}]}], 
        TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`u[n]\)]],
  " = ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", "\[NegativeThinSpace]", GridBox[{
              {\(F[n + 1]\)},
              {\(F[n]\)}
              }], ")"}], TraditionalForm]]],
  " y ",
  StyleBox["A",
    FontSlant->"Italic"],
  " es una matriz apropiada. Por tanto  ",
  Cell[BoxData[
      \(TraditionalForm\`u[n]\)]],
  " =",
  Cell[BoxData[
      \(TraditionalForm\`A\^\(n - 1\)\)]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(u[1]\),
          FontWeight->"Plain"], TraditionalForm]]],
  ", para todo ",
  StyleBox["n",
    FontSlant->"Italic"],
  " \[GreaterEqual] 2. En consecuencia, podemos calcular ",
  Cell[BoxData[
      \(TraditionalForm\`F[n]\)]],
  " calculando ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(A\^\(n - 1\)\), 
          FormBox[\(u[1]\),
            "TraditionalForm"], " "}], TraditionalForm]]],
  ". ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de un comando espec\[IAcute]fico para calcular potencias de una \
matriz. Utiliza dicho comando para definir una funci\[OAcute]n \"fibmatrix[n]\
\" que proporcione como respuesta el n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`F[n]\)]],
  " y \[UAcute]sala para calcular los n\[UAcute]meros F[k] para 120\
\[LessEqual]k\[LessEqual]140 n\[UAcute]meros de Fibonacci.  \n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Es muy f\[AAcute]cil calcular ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(A\^\(n - 1\)\), 
          FormBox[\(u[1]\),
            "TraditionalForm"]}], TraditionalForm]]],
  " si conocemos los valores propios de la matriz ",
  StyleBox["A",
    FontSlant->"Italic"],
  ". Sean ",
  StyleBox["a",
    FontSlant->"Italic"],
  " y ",
  StyleBox["b",
    FontSlant->"Italic"],
  " los valores propios de ",
  StyleBox["A",
    FontSlant->"Italic"],
  " con vectores propios ",
  Cell[BoxData[
      \(TraditionalForm\`x[a]\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(x[b]\ \)\)]],
  " (que debes calcular con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "). Calcula ",
  StyleBox["c",
    FontSlant->"Italic"],
  ", ",
  StyleBox["d",
    FontSlant->"Italic"],
  " tales que ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(u[1]\), "=", 
          RowBox[{
            RowBox[{"c", " ", 
              FormBox[\(x[a]\),
                "TraditionalForm"]}], "+", " ", 
            RowBox[{"d", " ", 
              FormBox[\(x[b]\),
                "TraditionalForm"]}]}]}], TraditionalForm]]],
  " y comprueba con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " (usando \"FullSimplify[",
  StyleBox["expr",
    FontSlant->"Italic"],
  "1==expr2]\") que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\(A\^\(n - 1\)\) u[1] = 
        c\ \(a\^\(n - 1\)\) x[a]\  + d\ \(b\^\(n - 1\)\) x[b]\ \)\)]],
  ". "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Soluci\[OAcute]n", "Subsubsection"],

Cell[BoxData[
    \(\(A = {{1, 1}, {1, 0}}; \)\)], "Input"],

Cell[BoxData[
    \(\(u[1] = {1, 1}; \)\)], "Input"],

Cell[BoxData[
    \(fibmatrix[n_] := Last[MatrixPower[A, n - 1] . u[1]]\)], "Input"],

Cell[BoxData[
    \(Table[fibmatrix[n], {n, 126, 140}]\)], "Input"],

Cell[BoxData[
    \({{a, b}, {x[a], x[b]}} = Eigensystem[A]\)], "Input"],

Cell[BoxData[
    \(val = \(Solve[u[1] == c*x[a] + d*x[b], {c, d}]\)[\([1]\)]; 
    \n{c, d} = FullSimplify[{c /. val, d /. val}]\)], "Input"],

Cell[BoxData[
    \(FullSimplify[MatrixPower[A, n] . u[1] == c*a\^n*x[a] + d*b\^n*x[b]]\)], 
  "Input"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 36, 0, 67, "Subsubsection"],
Cell[1815, 55, 2213, 68, 425, "Text"],
Cell[4031, 125, 1620, 47, 197, "Text"],
Cell[5654, 174, 167, 3, 124, "Input"],
Cell[5824, 179, 61, 1, 72, "Input"],
Cell[5888, 182, 279, 7, 67, "Text"],
Cell[6170, 191, 1160, 27, 171, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7367, 223, 41, 0, 67, "Subsubsection"],
Cell[7411, 225, 84, 1, 98, "Input"],
Cell[7498, 228, 66, 1, 72, "Input"],
Cell[7567, 231, 557, 10, 119, "Text"],
Cell[8127, 243, 98, 2, 98, "Input"],
Cell[8228, 247, 66, 1, 72, "Input"],
Cell[8297, 250, 445, 8, 254, "Input"],
Cell[8745, 260, 52, 1, 72, "Input"],
Cell[8800, 263, 295, 7, 67, "Text"],
Cell[9098, 272, 73, 1, 72, "Input"],
Cell[9174, 275, 209, 4, 73, "Input"],
Cell[9386, 281, 251, 5, 99, "Input"],
Cell[9640, 288, 82, 1, 72, "Input"],
Cell[9725, 291, 58, 1, 72, "Input"],
Cell[9786, 294, 41, 1, 72, "Input"],
Cell[9830, 297, 60, 1, 72, "Input"],
Cell[9893, 300, 64, 1, 72, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9994, 306, 36, 0, 67, "Subsubsection"],
Cell[10033, 308, 3399, 119, 252, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13469, 432, 41, 0, 67, "Subsubsection"],
Cell[13513, 434, 59, 1, 72, "Input"],
Cell[13575, 437, 52, 1, 72, "Input"],
Cell[13630, 440, 84, 1, 72, "Input"],
Cell[13717, 443, 67, 1, 72, "Input"],
Cell[13787, 446, 72, 1, 72, "Input"],
Cell[13862, 449, 142, 2, 98, "Input"],
Cell[14007, 453, 103, 2, 72, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

